#ifndef NETWORK_H_
#define NETWORK_H_

#include "sprites.h"

#define UDP_PACKET_PAYLOAD_OFFSET 42
#define UDP_PACKET_LENGTH_OFFSET 38

#define UDP_PACKET_PAYLOAD (transmit_buffer + UDP_PACKET_PAYLOAD_OFFSET)

#define MAX_MSG_LENGTH 128

#define TERRAIN_REDRAW_1 33
#define TERRAIN_REDRAW_2 34
#define TERRAIN_REDRAW_RECEIVE_1 35
#define TERRAIN_REDRAW_RECEIVE_2 36
#define SPRITE_SEND 37
#define SPRITE_SEND_RECEIVE 38

#define MAX_MSG_LENGTH 1500// Max size for our payload - more than necessary




unsigned char transmit_buffer[MAX_MSG_LENGTH] = {
  // Ethernet MAC header
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Destination MAC address
  0x01, 0x60, 0x6E, 0x11, 0x02, 0xCF, // Source MAC address
  0x08, 0x00,                         // Packet Type: 0x800 = IP
                          
  // IP Header
  0x45,                // version (IPv4), header length = 20 bytes
  0x00,                // differentiated services field
  0x00,0x9C,           // total length: 20 bytes for IP header +
                       // 8 bytes for UDP header + 128 bytes for payload
  0x3d, 0x35,          // packet ID
  0x00,                // flags
  0x00,                // fragment offset
  0x80,                // time-to-live
  0x11,                // protocol: 11 = UDP
  0xa3,0x43,           // header checksum: incorrect
  0xc0,0xa8,0x01,0x01, // source IP address
  0xc0,0xa8,0x01,0xff, // destination IP address
                          
  // UDP Header
  0x67,0xd9, // source port port (26585: garbage)
  0x27,0x2b, // destination port (10027: garbage)
  0x00,0x88, // length (136: 8 for UDP header + 128 for data)
  0x00,0x00, // checksum: 0 = none
                          
  // UDP payload
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67
};   
// Ethernet MAC address.  Choose the last three bytes yourself
unsigned char mac_address[6] = { 0x01, 0x60, 0x6E, 0x11, 0x02, 0xCF };

unsigned int interrupt_number;

float terrain[GAMEBOARD_LENGTH+1];
struct spriteStruct s[16];

int terrain_packet_num = 0;

short net_master = 0;

// Splits an integer into a two-byte char 
void splitInt(unsigned char* c, int x, int index){
    c[index+1] = x;
    c[index] = x >> 8;      
}

// Merges said two-byte char into a single integer
float mergeChars(unsigned char* c, int index){
    int x, y;
    x = 256*(int)c[index];
    y = (int)c[index+1];
    return (float)(x + y);      
}

// Checks the packet's integrity and extends/changes when necessary
int Check_Packet(unsigned char *data_ptr, int tx_len){
    int i;
    unsigned int temp_carry = 0x00; // Stores the carry-over used for 1's complement.
    unsigned int checksum = 0x00;
    int header = 0x00;
    unsigned int temp_len = 0;
    unsigned int packet_ID = 0; // The current packet's ID
    
    

    data_ptr[24] = 0x00;
    data_ptr[25] = 0x00;
    
    packet_ID = data_ptr[18]<<8 | (data_ptr[19]);
    packet_ID++;
    
    // Update the IP packet counter
    data_ptr[18] = packet_ID>>8;
    data_ptr[19] = packet_ID & 0xFF;
        
    // Computing the checksum by summing the header info, then taking the 1's complement
    for ( i=14; i<33; i +=2){
        header += ((data_ptr[i]<<8)|data_ptr[i+1]);
        //printf("%d = %x\n%d = %x\n", i, data_ptr[i], i+1, data_ptr[i+1]);
    }
    temp_carry = header >> 16;    
    checksum = 0xFFFF & ~(header + temp_carry); // Compute the checksum

    // Update the IP packet with the proper checksum
    data_ptr[24] = checksum>>8;
    data_ptr[25] = checksum & 0xFF;
    
    // Stuff the packet with additional data if not the minimal size.    
    if (64-tx_len > 0){
     
        for (i=tx_len; i < 64; i++){
            data_ptr[i] = 0;
        }
        temp_len = i;
    }
    
    data_ptr[38] = 0x00;
    data_ptr[39] = 0x00;
    data_ptr[40] = 0x00;
    data_ptr[41] = 0x00;
       
    // Update the packet with the proper length
    data_ptr[38] = tx_len >> 8;
    data_ptr[39] = tx_len & 0xFF;
    
    // Update the UDP packet checksum
    // Computing the checksum by summing the header info, then taking the 1's complement
    header = 0;
    //printf("%d\n", tx_len + 8); 
    for (i=34; i<39; i +=2)
        header += ((data_ptr[i]<<8)|data_ptr[i+1]);
    temp_carry = header >> 16;
    checksum = 0xFFFF & ~(header + temp_carry); // Compute the checksum
    
    // Update the UDP packet with the proper checksum
    data_ptr[40] = checksum>>8;
    data_ptr[41] = checksum & 0xFF;
    
    //for (i=0; i<tx_len; i++)
    //    printf("%d = %x\n", i, data_ptr[i]);
    
    return temp_len;
}


// Reads in the terrain data from the network
void read_terrain(float *terrainT, struct spriteStruct *worms, unsigned char* data, int size, int terrain_code){
    int i=0;
    size = size - (UDP_PACKET_PAYLOAD_OFFSET+2);
    size = size/2;
    for(i=0; i<size; i++){
        int index = UDP_PACKET_PAYLOAD_OFFSET+2+(i*2);
        terrainT[i] = mergeChars(data, index);             
    }
    
    if (terrain_code == TERRAIN_REDRAW_1){
        //drawTerrain(terrain, size, 0);
        for (i=0; i<GAMEBOARD_LENGTH/2; i++){
            terrain[i] = terrainT[i];
        }
    }
    else if (terrain_code == TERRAIN_REDRAW_2){
        for(i=0; i<GAMEBOARD_LENGTH/2; i++){
            terrain[(GAMEBOARD_LENGTH/2)+i] = terrainT[i];
        }
        for ( i = GAMEBOARD_LENGTH/2; i < (GAMEBOARD_LENGTH/2) + 4; i++){
             int index = UDP_PACKET_PAYLOAD_OFFSET+2+(i*2);
             worms[i- (GAMEBOARD_LENGTH/2)].h = mergeChars(data, index);    
        }
        drawTerrain(terrain, GAMEBOARD_LENGTH, 0);
    // Sprite synchronization received
    } else if (terrain_code == SPRITE_SEND){
        for(i=0; i<4; i++){
            
        }
    }

        
    if (terrain_code == TERRAIN_REDRAW_1)
        transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET] = TERRAIN_REDRAW_RECEIVE_1;        
    else if (terrain_code == TERRAIN_REDRAW_2)
        transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET] = TERRAIN_REDRAW_RECEIVE_2;

    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET+1] = 0;
    TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET+2);
    
    net_master = 0;        
    
}

void send_message( alt_u8 msg){
      printf("Msg to Send: "); 
      UDP_PACKET_PAYLOAD[1] = 0xAB;
      UDP_PACKET_PAYLOAD[1] = msg;
      UDP_PACKET_PAYLOAD[2] = 0; // Terminate the string
      unsigned int packet_length = UDP_PACKET_PAYLOAD_OFFSET + 2;
      
      transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
      transmit_buffer[UDP_PACKET_LENGTH_OFFSET+4 ] = packet_length & 0xff;
      if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + 3)==DMFE_SUCCESS) { 
        printf("\nMessage sent successfully\n");
      } else {
        printf("\nMessage sending failed\n"); 
      }
      // reset data
        int curMsgChar;
        for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
            UDP_PACKET_PAYLOAD[curMsgChar] = 0;
        }
     // }
      printf("Msg to Send: ");     
    
}

void send_terrain(int *msg, struct spriteStruct * worms, int start, int end, int terrain_code){
    int i=0;
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET] = terrain_code;
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET+1] = 0;
    int index;
    for(i=start; i<end; i++){        
        //transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET+i] = msg[i];
        index = UDP_PACKET_PAYLOAD_OFFSET+2+(2*i);
        splitInt(transmit_buffer, msg[i], index);        
    }
    if ( worms != NULL){
        for (i = end; i < end+4 ; i++){
          index   = UDP_PACKET_PAYLOAD_OFFSET+2+(2*i);
          splitInt(transmit_buffer, worms[i-end].h, index);      
            
        }
        
    }
    transmit_buffer[index+2] = 0;
    
    unsigned int packet_length = Check_Packet(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET+2*i);
    
    transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = packet_length >> 8;
    transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = packet_length & 0xff;
            
    
     if (TransmitPacket(transmit_buffer, index+2)==DMFE_SUCCESS) { 
               printf("\nMessage sent successfully\n");
               net_master = 1;
        
     } else {
               printf("\nMessage sending failed\n"); 
           }    
}

short getMaster(){
    return net_master;   
}



#endif /*NETWORK_H_*/
